// // // // // // // // // // // // // // // //
//
//	Enemy Territory - Scout.cc
//
//	erstellt 3.2.98 Andreas Warnke
//	geändert 23.2.98 von Andreas Warnke
//



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "Scout.h"
#include "Paradise.h"
#include "Ebene.h"
#include "Definitions.h"
#include "Heap.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

Scout :: Scout ( int inSize )
	: Welt ( inSize )
{
};



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

Scout :: ~Scout ()
{
	ParadiseList . MakeEmpty ( true );
};



// // // // // // // // // // // // // // // //
//
//	SetParadise:
//

void Scout :: SetParadise ( Objekt * inObj, int inToX, int inToY )
{
	//	gültige Parameter?
	if ( ( inObj == NULL ) || ( GetFieldType ( inToX, inToY ) == FT_EndOfWorld ) )
	{
		//	Drag to invalid location
		return;
	};
		
	//	bestimme current-time:
	bigtime_t sNow = real_time_clock_usecs ();
		
	//	ist Objekt schon in Liste?
	int i = ParadiseList . CountElements ();
	while ( i > 0 )
	{
		i--;
		Paradise * sFinger = (Paradise*) ParadiseList . GetElement ( i );
		if ( sFinger -> ID == inObj -> GetID () )
			//	Objekt existiert schon.
			//	altes löschen:
			delete sFinger;
	};
	
	//	Erstelle Objekt, und füge es ein:
	Paradise * sNewParadise = new Paradise ( inObj, inToX, inToY );
	if ( sNewParadise != NULL )
		if ( ! ParadiseList . Insert ( (Element*) sNewParadise ) )
		{
			//	Unexpected Error
			delete sNewParadise;
		}
		else {}
	else
	{
		//	Out of memory
	};
};



// // // // // // // // // // // // // // // //
//
//	SearchBestMove
//

bool Scout :: SearchBestMove ( Objekt * inObj, int inTimeOut )
{
	//	Parametercheck:
	if ( inObj == NULL )
		return false;
		
	//	Suche Objekt in der Paradise-Liste:
	int i = ParadiseList . CountElements ();
	bigtime_t sNow = real_time_clock_usecs(); 
	while ( i > 0 )
	{
		i--;
		Paradise * sFinger = (Paradise*) ParadiseList . GetElement ( i );
		if ( sFinger -> Timeout < sNow )
		{
			//	Timeout
			delete sFinger;
		}
		else if ( sFinger -> ID == inObj -> GetID () )
		{
			//	Zielposition (Paradies) des Objekts ermittelt.
			if ( ( sFinger -> NextX != inObj -> XPos )
				|| ( sFinger -> NextY != inObj -> YPos ) )
				//	Noch nicht angekommen.
				return false;
			else
			{
				//	Das Objekt hat sich korrekt bewegt.
				if ( ( sFinger -> ParadiseX == inObj -> XPos )
					&& ( sFinger -> ParadiseY == inObj -> YPos ) )
				{
					//	Das Objekt ist angekommen.
					delete sFinger;
					return false;
				};
					
				//	Speichere jetzige Position:
				sFinger -> LastX = inObj -> XPos;
				sFinger -> LastY = inObj -> YPos;
				//	Nächsten Schritt berechnen:
				if ( A_Star_Search ( sFinger, inTimeOut ) )
				{
					//	neues Timeout ( siehe auch Konstruktor von Paradise!) :
					sFinger -> Timeout = real_time_clock_usecs () + FD_Communication + GetFieldDelay ( sFinger -> LastX, sFinger -> LastY );
					//	Speichere Next - Pos im objekt:
					inObj -> MoveToX = sFinger -> NextX;
					inObj -> MoveToY = sFinger -> NextY;
					return true;		
				}
				else
				{
					//	Es gibt keinen Weg.
					delete sFinger;
					return false;
				};
			};
		};
	};
	
	//	kein Paradies gefunden.
	return false;
};



// // // // // // // // // // // // // // // //
//
//	A_Star_Search
//

class FieldInfo : private Element, protected HeapElement < bigtime_t >
{
public:
	int X;
	int Y;
	FieldInfo * From;
	bigtime_t CostFromStart;
	
public:
	//	Konstruktor:
	FieldInfo ( int inX, int inY, FieldInfo * inFrom, bigtime_t inStart, bigtime_t inParadise )
		: HeapElement < bigtime_t > ( inStart + inParadise )
		{ X = inX; Y = inY; From = inFrom; CostFromStart = inStart; };
};

bool Scout :: A_Star_Search ( Paradise * ioZiel, int inTimeOut )
{
	//	Parametercheck:
	if ( ioZiel == NULL )
		return false;
	
	//	Problembeschreibung:
	int sFromX = ioZiel -> LastX;
	int sFromY = ioZiel -> LastY;
	int sToX = ioZiel -> ParadiseX;
	int sToY = ioZiel -> ParadiseY;

	//	Erstelle Ready:	
	ElementList Ready;
	int IsReadyWidth = (( Width + 7 ) / 8 );
	uint8 * IsReady = new uint8 [ IsReadyWidth * Height ];
	if ( IsReady == NULL )
		return false;
	int sReadyInit = IsReadyWidth * Height;
	while ( sReadyInit > 0 )
	{
		sReadyInit --;
		IsReady [ sReadyInit ] = 0;
	};
	
	//	Erstelle ToDoHeap:	
	Heap < bigtime_t > ToDo;
	ToDo . Insert ( (HeapElement<bigtime_t>*) new FieldInfo (
		sFromX,
		sFromY,
		NULL,
		0,
		FD_Heuristik * Distance ( sFromX, sFromY, sToX, sToY ) ) );
	
	//	Solange das kleinste der ToDo - Liste != Paradise:
	FieldInfo * sFastest = NULL;
	do
	{
		//	Ermittle das Kleinste der ToDo-Liste:
		sFastest = (FieldInfo*) ToDo . DeleteMin ();
		
		inTimeOut --;
		if ( ( sFastest == NULL ) || ( inTimeOut < 0 ) )
		{
			//	Es gibt keinen Weg oder die Rechenzeit ist aus.
			delete sFastest;
			Ready . MakeEmpty ( true );
			delete [] IsReady;
			return false;
		};
		
		if ( ( sFastest -> X == sToX ) && ( sFastest -> Y == sToY ) )
			//	kuerzesten Weg zum Ziel gefunden.
			//	beende While-Schleife:
			break;

		int sX = sFastest -> X;
		int sY = sFastest -> Y;
		int IsReadyPos = (sX / 8) + IsReadyWidth * sY;
		if ( ( ( IsReady [ IsReadyPos ] >> (sX & 7) ) & 1 ) == 1 )
			//	sFastest ist schon berechnet. 
			delete sFastest;
		else
		{
			//	sFastest ist ein neues Feld.
			//	Expandiere sFastest:
			Ready . Insert ( (Element*) sFastest );
			IsReady [ IsReadyPos ] = IsReady [ IsReadyPos ] | ( 1 << (sX & 7) );
			for ( int i = 6; i > 0; i-- )
			{
				//	Bestimme koordinaten des i-ten Kandidaten
				sX = sFastest -> X;
				sY = sFastest -> Y;
				if ( i >= 5 )
					sY ++;
				if ( i <= 2 )
					sY --;
				if ( i == 3 )
					sX --;
				if ( i == 4 )
					sX ++;
				if (( i == 1 ) || ( i == 6 ))
					if ( IsShiftRight ( sY ) )
						sX --;
					else
						sX ++;
						
				bigtime_t sStepCost = GetFieldDelay ( sX, sY );
				if ( sStepCost < FD_NoWay )
				{
					//	Kandidat ist kein Wasser.
					//	Prüfe, ob Feld in Ready-Liste ist:
					IsReadyPos = (sX / 8) + IsReadyWidth * sY;
					if ( ( ( IsReady [ IsReadyPos ] >> (sX & 7) ) & 1 ) == 0 )
					{
						//	Das Feld ist noch nicht in Ready-Liste.
						//	Nimm ( sX, sY ) in Liste auf:
						ToDo . Insert ( (HeapElement<bigtime_t>*) new FieldInfo (
							sX,
							sY,
							sFastest,
							sFastest -> CostFromStart + sStepCost,
							FD_Heuristik * Distance ( sX, sY, sToX, sToY ) ) );
					};
				}
				else
				{
					//	Nachfolger-Kandidat ist Wasser
					if ( ( sX == sToX ) && ( sY == sToY ) )
					{
						//	Zielfeld ist wasser.
						//	Error: You can't swim.
						delete sFastest;
						Ready . MakeEmpty ( true );
						delete [] IsReady;
						return false;
					};
				};
			};
			//	End: Expandiere sFastest.
		};
	}
	while ( true );
		
	//	Bestimme Weg zu sFastest:
	if ( sFastest -> From == NULL )
	{
		//	Ich bin schon am Ziel.
		delete sFastest;
		Ready . MakeEmpty ( true );
		delete [] IsReady;
		return false;
	};
	while ( sFastest -> From -> From != NULL )
	{
		sFastest = sFastest -> From;
	};
	
	//	Optimalen Schritt gefunden:
	ioZiel -> NextX = sFastest -> X;
	ioZiel -> NextY = sFastest -> Y;
		
	//	Fertig:
	delete sFastest;
	Ready . MakeEmpty ( true );
	delete [] IsReady;
	return true;
};



//
//	Ende
//
// // // // // // // // // // // // // // // //